/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpManager.Admin.CanvasSettings;
import ibm.nways.analysis.dpManager.Admin.DPETopology;
import ibm.nways.analysis.dpManager.Admin.NetworkDisplay;
import ibm.nways.analysis.dpManager.Admin.NetworkNode;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;

public class PanViewCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    private MouseEvent mouseEvt;
    private MouseEvent mouse_dragged;
    private MouseEvent mouse_pressed;
    private MouseEvent mouse_released;
    private NetworkDisplay ND;
    private int flag;
    private boolean mouseIsOver = false;
    private boolean mouseIsDragging = false;
    private boolean mouseWasReleased = false;
    private boolean mouseReleasedOverServer = false;
    private boolean serverNodeFound = false;
    private boolean nodeFound = false;
    private boolean nFound = false;
    private boolean nodeFnd = false;
    private Font nodeFont;
    private FontMetrics fmetrics;
    Dimension dim;
    private Graphics graphics;
    private DPETopology dpeTop;
    private NetworkNode draggedNode;
    private NetworkNode mouseOverNode;
    private CanvasSettings cSetting;
    private Image offScreenImage;
    private Graphics offScreenGraphics;
    private Dimension offScreenSize;
    private int mouse_x;
    private int mouse_y;

    public PanViewCanvas(DPETopology dPETopology) {
        this.ND = dPETopology.getNDRef();
        this.dpeTop = dPETopology;
        this.cSetting = new CanvasSettings(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public MouseEvent getMouseEvent() {
        return this.mouseEvt;
    }

    public Dimension getPreferredSize() {
        return new Dimension(750, 400);
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    public void identifyImageMouseIsOver(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            int n3;
            int n4;
            int n5;
            int n6;
            NetworkNode networkNode = this.dpeTop.getServerNode();
            int n7 = networkNode.getNodeX();
            int n8 = networkNode.getNodeY();
            String string = networkNode.getNodeLabel();
            if (!this.nodeFound) {
                n6 = n7 - 20;
                n5 = n7 + 20;
                n4 = n8 - 16;
                n3 = n8 + 16;
                if (n6 <= n && n <= n5 && n4 <= n2 && n2 <= n3) {
                    this.mouseIsOver = true;
                    this.mouseOverNode = networkNode;
                    this.repaint();
                    this.nFound = true;
                    this.serverNodeFound = true;
                }
            }
            if (!this.serverNodeFound) {
                Enumeration enumeration = this.dpeTop.getAssNodeStorage().elements();
                while (enumeration.hasMoreElements()) {
                    networkNode = (NetworkNode)enumeration.nextElement();
                    n7 = networkNode.getNodeX();
                    n8 = networkNode.getNodeY();
                    string = networkNode.getNodeLabel();
                    if (this.nFound) continue;
                    n6 = n7 - 10;
                    n5 = n7 + 10;
                    n4 = n8 - 10;
                    n3 = n8 + 10;
                    if (n6 > n || n > n5 || n4 > n2 || n2 > n3) continue;
                    this.mouseIsOver = true;
                    this.mouseOverNode = networkNode;
                    this.repaint();
                    this.nFound = true;
                }
            }
        }
    }

    public void identifyImageClicked(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = mouseEvent;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (mouseEvent2.getID() == 500) {
            Enumeration enumeration = this.dpeTop.getAssNodeStorage().elements();
            while (enumeration.hasMoreElements()) {
                NetworkNode networkNode = (NetworkNode)enumeration.nextElement();
                int n4 = networkNode.getNodeX();
                int n5 = networkNode.getNodeY();
                String string = networkNode.getNodeLabel();
                if (this.nodeFnd) continue;
                int n6 = n4 - 10;
                int n7 = n4 + 10;
                int n8 = n5 - 10;
                int n9 = n5 + 10;
                if (n6 > n || n > n7 || n8 > n2 || n2 > n9 || n3 != 2) continue;
                this.nodeFnd = true;
                if (mouseEvent.isControlDown()) {
                    this.ND.showDPEConfig(string);
                    continue;
                }
                this.ND.showDpeMon(string);
            }
        }
    }

    public void identifyImageDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Enumeration enumeration = this.dpeTop.getUnAssNodeStorage().elements();
        while (enumeration.hasMoreElements()) {
            NetworkNode networkNode = (NetworkNode)enumeration.nextElement();
            int n3 = networkNode.getNodeX();
            int n4 = networkNode.getNodeY();
            String string = networkNode.getNodeLabel();
            if (this.nodeFound) continue;
            int n5 = n3 - 10;
            int n6 = n3 + 10;
            int n7 = n4 - 10;
            int n8 = n4 + 10;
            if (n5 > n || n > n6 || n7 > n2 || n2 > n8) continue;
            this.draggedNode = networkNode;
            this.cSetting.drawImageDragged(this.graphics, n, n2, this.draggedNode.getNodeLabel());
            this.nodeFound = true;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseEvt = mouseEvent;
        this.identifyImageClicked(this.mouseEvt);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_pressed = mouseEvent;
        this.mouseWasReleased = false;
        this.mouseReleasedOverServer = false;
        if (this.dpeTop.getAssNodeStorage().size() > 25) {
            this.identifyImageMouseIsOver(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsOver = false;
        this.repaint();
        this.serverNodeFound = false;
        this.nFound = false;
        this.nodeFnd = false;
        if (this.mouseIsDragging && this.draggedNode != null) {
            this.mouse_released = mouseEvent;
            int n = this.mouse_released.getX();
            int n2 = this.mouse_released.getY();
            int n3 = this.dpeTop.getServerNode().getNodeX() - 20;
            int n4 = this.dpeTop.getServerNode().getNodeX() + 12;
            int n5 = this.dpeTop.getServerNode().getNodeY() - 20;
            int n6 = this.dpeTop.getServerNode().getNodeY() + 12;
            if (n3 <= n && n <= n4 && n5 <= n2 && n2 <= n6) {
                this.mouseReleasedOverServer = true;
                this.ND.showDPEConfig(this.draggedNode.getNodeLabel());
            } else {
                this.mouseWasReleased = true;
                this.draggedNode = null;
                this.repaint();
            }
        }
        this.mouseIsDragging = false;
        this.nodeFound = false;
    }

    public NetworkNode getDraggedNode() {
        return this.draggedNode;
    }

    public void setDraggedNode() {
        this.draggedNode = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouse_dragged = mouseEvent;
        this.mouse_x = this.mouse_dragged.getX();
        this.mouse_y = this.mouse_dragged.getY();
        if (!this.mouseIsDragging) {
            this.identifyImageDragged(this.mouse_dragged);
        }
        this.mouseIsDragging = true;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void clearCanvas(Graphics graphics) {
        super.paint(graphics);
        this.dim = this.getSize();
        String string = null;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.dim.width, this.dim.height);
        string = this.dpeTop.getAdminPanel().getServerName();
        if (string != null) {
            this.dpeTop.createServerNode(string);
            this.dpeTop.setServerNodePosition(this.dim.width / 2, this.dim.height / 2);
            ++this.flag;
        }
        this.cSetting.drawKey(graphics, this.dim);
    }

    public void update(Graphics graphics) {
        if (this.offScreenImage == null || this.dim.width != this.offScreenSize.width || this.dim.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(this.dim.width, this.dim.height);
            this.offScreenSize = this.dim;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        graphics.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        this.graphics = graphics;
        this.fmetrics = graphics.getFontMetrics();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.clearCanvas(graphics);
        n2 = this.dim.width / 2;
        n3 = this.dim.height / 2;
        n = 3 * this.dim.height / 10;
        this.cSetting.drawAssignedDPEs(this.graphics, this.dpeTop.getAssNodeStorage(), this.fmetrics, this.dpeTop.getServerNode(), n);
        this.cSetting.drawUnAssignedDPEs(this.graphics, this.dpeTop.getUnAssNodeStorage());
        if (this.mouseIsOver) {
            this.cSetting.drawNodeLabel(this.graphics, this.mouseOverNode, this.fmetrics);
        }
        if (this.mouseIsDragging && this.draggedNode != null) {
            this.cSetting.drawImageDragged(this.graphics, this.mouse_x, this.mouse_y, this.draggedNode.getNodeLabel());
        }
    }
}

